<?php
session_start();
require_once __DIR__.'/../../includes/db.php';
require_once __DIR__.'/../../includes/functions.php';
require_once __DIR__.'/../../includes/config.php';

$id = (int)($_GET['id'] ?? 0);

// Ambil data produk
$stmt = $pdo->prepare("
    SELECT p.*, c.category_id, c.name as category_name
    FROM products p
    JOIN categories c ON p.category_id = c.category_id
    WHERE p.product_id = ? LIMIT 1
");
$stmt->execute([$id]);
$product = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$product) {
    echo "<div class='site-container'><p>Produk tidak ditemukan.</p></div>";
    exit;
}

// Handle Add to Cart — dilakukan sebelum output HTML
if (isset($_POST['add_to_cart'])) {
    $qty = max(1, (int)$_POST['qty']);
    $_SESSION['cart'][$id] = [
        'name'  => $product['name'],
        'price' => $product['price'],
        'qty'   => $qty,
        'type'  => $product['type'] ?? 'non-digital'
    ];
    header("Location: index.php?page=cart");
    exit;
}

$categoryPath = getCategoryPathArray($product['category_id'], $pdo);
?>

<div class="site-container">
  <!-- Breadcrumb -->
  <div class="breadcrumb">
    <a href="index.php">Home</a> >
    <?php foreach($categoryPath as $i => $cat): ?>
      <?php if ($i < count($categoryPath)-1): ?>
        <a href="index.php?page=products&cat=<?= $cat['category_id'] ?>"><?= htmlspecialchars($cat['name']) ?></a> >
      <?php else: ?>
        <span><?= htmlspecialchars($cat['name']) ?></span>
      <?php endif; ?>
    <?php endforeach; ?>
    > <?= htmlspecialchars($product['name']) ?>
  </div>

  <!-- Layout dua kolom -->
  <div class="layout-2col">
    <!-- Main -->
    <div class="main">
      <div class="product-card">
        <img src="../../<?= getProductImage($product['image']) ?>">
        <h3><?= htmlspecialchars($product['name']) ?></h3>
        <div class="price"><?= rupiah($product['price']) ?></div>
        <p><?= nl2br($product['description']) ?></p>

        <?php if ((int)$product['stock'] > 0): ?>
          <form method="POST" style="margin-top:15px;">
            <label for="qty">Jumlah:</label>
            <input type="number" name="qty" id="qty" value="1" min="1" max="<?= (int)$product['stock'] ?>" style="width:70px;">
            <button type="submit" name="add_to_cart" class="btn btn-success">+ Keranjang</button>
          </form>
        <?php else: ?>
          <p style="color:red;"><strong>Stok Habis</strong></p>
        <?php endif; ?>
      </div>
    </div>

    <!-- Sidebar -->
    <div class="sidebar">
      <h3>Kategori</h3>
      <?php getCategoryTree(null, $pdo); ?>
    </div>
  </div>
</div>
