<div class="breadcrumb">
  <a href="index.php">Home</a> >
  <?php foreach($categoryPath as $i => $cat): ?>
    <?php if ($i < count($categoryPath)-1): ?>
      <a href="index.php?page=products&cat=<?= $cat['category_id'] ?>"><?= htmlspecialchars($cat['name']) ?></a> >
    <?php else: ?>
      <span><?= htmlspecialchars($cat['name']) ?></span>
    <?php endif; ?>
  <?php endforeach; ?>
  > <?= htmlspecialchars($product['name']) ?>
</div>

<div class="layout-2col">
  <div class="main">
    <div class="product-card">
      <img src="../../<?= getProductImage($product['image']) ?>">
      <h3><?= htmlspecialchars($product['name']) ?></h3>
      <div class="price"><?= rupiah($product['price']) ?></div>
      <p><?= nl2br($product['description']) ?></p>

      <?php if ($product['stock'] > 0): ?>
        <form method="POST" class="mt-3">
          <label for="qty">Jumlah:</label>
          <input type="number" name="qty" id="qty" value="1" min="1" max="<?= (int)$product['stock'] ?>" style="width:70px; margin:0 10px;">
          <button type="submit" name="add_to_cart" class="btn btn-success">+ Keranjang</button>
        </form>
      <?php else: ?>
        <p style="color:red;"><strong>Stok Habis</strong></p>
      <?php endif; ?>
    </div>
  </div>

  <div class="sidebar">
    <h3>Kategori</h3>
    <?php getCategoryTree(null, $pdo); ?>
  </div>
</div>
