<?php
require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/functions.php';
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/user_auth.php';

$orderId = (int)($_GET['order_id'] ?? 0);

// Ambil data order
$stmt = $pdo->prepare("
    SELECT o.*, u.name, u.email, u.phone 
    FROM orders o 
    JOIN user_tbl u ON o.user_id = u.user_id 
    WHERE o.order_id=? AND o.user_id=?
");
$stmt->execute([$orderId, $_SESSION['user_id']]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$order) {
    die("<div class='card'>Order tidak ditemukan.</div>");
}

$msg = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $metode  = cleanInput($_POST['payment_method']);
    $noKartu = cleanInput($_POST['card_number']);
    $jumlah  = (float)$_POST['amount'];

    // Validasi bukti pembayaran
    if (!isset($_FILES['proof']) || $_FILES['proof']['error'] !== UPLOAD_ERR_OK) {
        $msg = "Upload bukti pembayaran gagal. Silakan coba lagi.";
    } else {
        $allowedExt = ['jpg', 'jpeg', 'png', 'pdf'];
        $fileExt = strtolower(pathinfo($_FILES['proof']['name'], PATHINFO_EXTENSION));

        if (!in_array($fileExt, $allowedExt)) {
            $msg = "Format file tidak diizinkan. Gunakan JPG/PNG/PDF.";
        } else {
            // Upload file bukti pembayaran
            $uploadDir = __DIR__ . '/../../user/uploads/payments/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }

            $fileName = time() . "_" . preg_replace('/[^a-zA-Z0-9_\.-]/', '_', basename($_FILES['proof']['name']));
            $targetFile = $uploadDir . $fileName;

            if (move_uploaded_file($_FILES['proof']['tmp_name'], $targetFile)) {
                // Simpan ke DB
                $stmtIns = $pdo->prepare("
                    UPDATE orders 
                    SET payment_method=?, card_number=?, payment_amount=?, payment_proof=?, status='pending' 
                    WHERE order_id=? AND user_id=?
                ");
                $stmtIns->execute([$metode, $noKartu, $jumlah, $fileName, $orderId, $_SESSION['user_id']]);

                // Kirim email ke admin
                require_once __DIR__ . '/../../includes/mailer.php';
                require_once __DIR__ . '/../../includes/email_templates.php';
                $adminEmail = getSetting('site_email', $pdo);
                $body = emailTemplatePaymentConfirm($order, $metode, $noKartu, $jumlah, $fileName);

                sendEmail($adminEmail, "Admin", "Konfirmasi Pembayaran Order #{$order['order_id']}", $body);

                $msg = "✅ Konfirmasi pembayaran berhasil dikirim ke admin.";
            } else {
                $msg = "Gagal mengunggah bukti pembayaran.";
            }
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Konfirmasi Pembayaran - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../../assets/css/style.css">
</head>
<body>
<div class="container">
<div class="card">
<h2>Konfirmasi Pembayaran</h2>

<?php if ($msg): ?>
    <div class="card-info"><?= $msg ?></div>
<?php else: ?>
<form method="POST" enctype="multipart/form-data">
    <h3>Data Order:</h3>
    <p>No Order: <strong><?= $order['order_id'] ?></strong></p>
    <p>Tanggal Order: <?= $order['created_at'] ?></p>
    <p>Nama Pembeli: <?= $order['name'] ?></p>
    <p>Alamat Email: <?= $order['email'] ?></p>
    <p>No Telp: <?= $order['phone'] ?></p>

    <h3>Data Pembayaran:</h3>
    <label>Metode Pembayaran</label>
    <select name="payment_method" required>
        <option value="">-- Pilih --</option>
        <option value="Transfer Bank">Transfer Bank</option>
        <option value="Debit/Credit Card">Debit/Credit Card</option>
        <option value="QRIS">QRIS</option>
        <option value="Lainnya">Lainnya</option>
    </select>

    <label>No CC / Debit Card</label>
    <input type="text" name="card_number" placeholder="Opsional">

    <label>Jumlah Pembayaran</label>
    <input type="number" name="amount" step="0.01" required>

    <label>Bukti Pembayaran (JPG/PNG/PDF)</label>
    <input type="file" name="proof" accept=".jpg,.jpeg,.png,.pdf" required>

    <button type="submit" class="btn btn-success">Kirim Konfirmasi</button>
</form>
<?php endif; ?>
</div>
</div>
</body>
</html>
