<?php
require_once '../includes/db.php';
require_once '../includes/user_auth.php';
require_once '../includes/functions.php';

$orderId = (int)$_GET['id'];

// Ambil order + protect by user_id
$stmt = $pdo->prepare("SELECT * FROM orders WHERE order_id=? AND user_id=?");
$stmt->execute([$orderId, $_SESSION['user_id']]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$order) die("Order tidak ditemukan");

$stmtItems = $pdo->prepare("SELECT oi.*, p.name, p.type FROM order_items oi JOIN products p ON oi.product_id=p.product_id WHERE oi.order_id=?");
$stmtItems->execute([$orderId]);
$items = $stmtItems->fetchAll(PDO::FETCH_ASSOC);

$digital = $pdo->prepare("SELECT * FROM digital_delivery WHERE order_id=?");
$digital->execute([$orderId]);
$digitalLinks = $digital->fetchAll(PDO::FETCH_ASSOC);

$shipments = $pdo->prepare("SELECT * FROM shipments WHERE order_id=?");
$shipments->execute([$orderId]);
$shipmentData = $shipments->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Detail Order #<?= $orderId ?> - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container">
    <h2>Order #<?= $orderId ?></h2>
    <p>Status: <?= ucfirst($order['status']) ?></p>

    <h3>Produk</h3>
    <ul>
        <?php foreach ($items as $i): ?>
        <li><?= $i['name'] ?> × <?= $i['qty'] ?> - <?= rupiah($i['price']) ?> (<?= ucfirst($i['type']) ?>)</li>
        <?php endforeach; ?>
    </ul>

    <?php if ($digitalLinks): ?>
    <h3>Link Download</h3>
    <ul>
        <?php foreach ($digitalLinks as $d): ?>
        <li><a href="<?= $d['link_download'] ?>" target="_blank"><?= $d['link_download'] ?></a></li>
        <?php endforeach; ?>
    </ul>
    <?php endif; ?>

    <?php if ($shipmentData): ?>
    <h3>Pengiriman</h3>
    <?php foreach ($shipmentData as $s): ?>
        <p>Kurir: <?= $s['courier'] ?> | No Resi: <?= $s['tracking_no'] ?></p>
    <?php endforeach; ?>
    <?php endif; ?>
</div>
</body>
</html>
