<?php
require_once '../includes/db.php';
require_once '../includes/functions.php';
session_start();

// Affiliate tracking lewat ?affid=
if (isset($_GET['affid'])) {
    setAffiliateCookie($_GET['affid']);
}

$category_id = isset($_GET['cat']) ? (int)$_GET['cat'] : null;

$sql = "SELECT * FROM products";
if ($category_id) {
    $sql .= " WHERE category_id = :cat";
}
$stmt = $pdo->prepare($sql);
if ($category_id) {
    $stmt->bindValue(':cat', $category_id, PDO::PARAM_INT);
}
$stmt->execute();
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);

?>
<!DOCTYPE html>
<html>
<head>
    <title>Produk - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<header>
    <h1><?= SITE_NAME ?></h1>
    <nav>
        <a href="index.php">Home</a> | 
        <a href="cart.php">Cart</a> | 
        <?php if (!empty($_SESSION['user_id'])): ?>
            <a href="logout.php">Logout</a>
        <?php else: ?>
            <a href="login.php">Login</a> | <a href="register.php">Register</a>
        <?php endif; ?>
    </nav>
</header>
<div class="container">
    <h2>Kategori</h2>
    <?php getCategories(null, $pdo); ?>

    <h2>Produk</h2>
    <div class="products-grid">
    <?php foreach ($products as $p): ?>
        <div class="card">
            <img src="../assets/img/<?= $p['image'] ?>" alt="<?= $p['name'] ?>" class="img-responsive" loading="lazy">
            <h3><?= $p['name'] ?></h3>
            <p><?= rupiah($p['price']) ?></p>
            <a href="product.php?id=<?= $p['product_id'] ?>" class="btn btn-primary">Detail</a>
        </div>
    <?php endforeach; ?>
    </div>
</div>
</body>
</html>
