<?php
$categories = $pdo->query("SELECT * FROM categories WHERE parent_id IS NULL ORDER BY name ASC LIMIT 6")->fetchAll(PDO::FETCH_ASSOC);
$latestProducts = $pdo->query("SELECT * FROM products ORDER BY created_at DESC LIMIT 8")->fetchAll(PDO::FETCH_ASSOC);
$articles = $pdo->query("SELECT * FROM articles ORDER BY created_at DESC LIMIT 3")->fetchAll(PDO::FETCH_ASSOC);
?>
<h2 class="section-title">Kategori Unggulan</h2>
<div class="products-grid">
  <?php foreach($categories as $cat): ?>
    <a href="index.php?page=products&cat=<?= $cat['category_id'] ?>" class="product-card">
      <img src="assets/images/default-category.jpg">
      <h3><?= htmlspecialchars($cat['name']) ?></h3>
    </a>
  <?php endforeach; ?>
</div>

<h2 class="section-title">Produk Terbaru</h2>
<div class="products-grid">
  <?php foreach($latestProducts as $p): ?>
    <a href="index.php?page=product_detail&id=<?= $p['product_id'] ?>" class="product-card">
      <img src="<?= getProductImage($p['image']) ?>">
      <h3><?= htmlspecialchars($p['name']) ?></h3>
      <div class="price"><?= rupiah($p['price']) ?></div>
    </a>
  <?php endforeach; ?>
</div>

<h2 class="section-title">Artikel Terbaru</h2>
<div class="article-grid">
  <?php foreach($articles as $a): ?>
    <div class="article-card">
      <a href="index.php?page=article_detail&id=<?= $a['article_id'] ?>">
        <img src="<?= getProductImage($a['cover_image']) ?>">
        <div class="article-card-content">
          <h3><?= htmlspecialchars($a['title']) ?></h3>
          <p class="article-meta"><?= date('d M Y', strtotime($a['created_at'])) ?></p>
        </div>
      </a>
    </div>
  <?php endforeach; ?>
</div>
