<?php
require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/functions.php';
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/user_auth.php';

$orderId = (int)($_GET['order_id'] ?? 0);

$stmt = $pdo->prepare("SELECT o.*, u.name, u.email, u.phone 
    FROM orders o 
    JOIN user_tbl u ON o.user_id=u.user_id 
    WHERE o.order_id=? AND o.user_id=? AND o.status='paid'");
$stmt->execute([$orderId, $_SESSION['user_id']]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$order) {
    die("<div class='card'>Order tidak ditemukan atau belum bisa dikonfirmasi.</div>");
}

$items = $pdo->prepare("SELECT p.name, oi.qty, oi.price FROM order_items oi JOIN products p ON oi.product_id=p.product_id WHERE oi.order_id=?");
$items->execute([$orderId]);
$produkList = $items->fetchAll(PDO::FETCH_ASSOC);

$totalHarga = array_sum(array_map(fn($p) => $p['price'] * $p['qty'], $produkList));
$msg = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $pdo->prepare("UPDATE orders SET status='delivered' WHERE order_id=? AND user_id=?")->execute([$orderId, $_SESSION['user_id']]);

    // Email admin
    require_once __DIR__ . '/../../includes/mailer.php';
    $adminEmail = getSetting('site_email', $pdo);

    $produkHTML = "<ul>";
    foreach ($produkList as $p) {
        $produkHTML .= "<li>{$p['name']} ({$p['qty']})</li>";
    }
    $produkHTML .= "</ul>";

    require_once __DIR__ . '/../../includes/email_templates.php';
$body = emailTemplateDigitalConfirm($order, $produkList, $totalHarga);
    sendEmail($adminEmail, "Admin", "Konfirmasi Terima Produk Digital - Order #{$order['order_id']}", $body);

    $msg = "Terima kasih! Konfirmasi penerimaan Anda telah dikirim ke admin.";
}
?>

<div class="card">
<h2>Konfirmasi Penerimaan Produk Digital</h2>
<?php if ($msg): ?>
    <div class="card-info"><?= $msg ?></div>
<?php else: ?>
<p>Dear Admin, dengan ini saya mengkonfirmasi telah menerima produk yang saya beli:</p>

<h3>Data Order:</h3>
<p>No Order: <?= $order['order_id'] ?></p>
<ul>
<?php foreach ($produkList as $p): ?>
    <li><?= $p['name'] ?> (<?= $p['qty'] ?>)</li>
<?php endforeach; ?>
</ul>
<p>Total Harga: <?= rupiah($totalHarga) ?></p>

<form method="POST">
    <p>Saya mengkonfirmasi dengan sebenarnya bahwa saya sudah menerima barang tersebut di atas.</p>
    <p>Nama Pembeli: <strong><?= $order['name'] ?></strong></p>
    <button type="submit" class="btn btn-success">Konfirmasi Terima</button>
</form>
<?php endif; ?>
</div>
