<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/functions.php';
require_once __DIR__ . '/../../includes/config.php';

// Ambil info kontak dari settings
$siteEmail   = getSetting('site_email', $pdo);
$sitePhone   = getSetting('site_phone', $pdo) ?: '-';
$siteAddress = getSetting('site_address', $pdo) ?: '-';

$msg = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name    = cleanInput($_POST['name']);
    $email   = cleanInput($_POST['email']);
    $message = cleanInput($_POST['message']);

    if (!$name || !$email || !$message) {
        $msg = "⚠ Harap isi semua form.";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $msg = "⚠ Alamat email tidak valid.";
    } else {
        // Kirim email ke admin
        require_once __DIR__ . '/../../includes/mailer.php';
        $body = "
            <p>Pesan baru dari halaman Contact:</p>
            <p><strong>Nama:</strong> {$name}</p>
            <p><strong>Email:</strong> {$email}</p>
            <p><strong>Pesan:</strong><br>" . nl2br($message) . "</p>
        ";

        if (sendEmail($siteEmail, "Admin", "Pesan dari {$name}", $body)) {
            $msg = "✅ Pesan berhasil dikirim. Kami akan segera merespon.";
        } else {
            $msg = "❌ Gagal mengirim pesan. Coba lagi nanti.";
        }
    }
}
?>
<div class="site-container contact-layout">
    <h2 class="section-title">Kontak Kami</h2>

    <div class="contact-wrapper">
        <!-- Form Kontak -->
        <div class="contact-form">
            <?php if (!empty($msg)): ?>
                <div class="alert"><?= $msg ?></div>
            <?php endif; ?>

            <form method="POST">
                <label>Nama</label>
                <input type="text" name="name" required>

                <label>Email</label>
                <input type="email" name="email" required>

                <label>Pesan</label>
                <textarea name="message" rows="5" required></textarea>

                <button type="submit" class="btn btn-success">Kirim Pesan</button>
            </form>
        </div>

        <!-- Info Kontak -->
        <div class="contact-info">
            <h3>Info Kontak</h3>
            <p><strong>Email:</strong> <?= htmlspecialchars($siteEmail) ?></p>
            <p><strong>Telepon:</strong> <?= htmlspecialchars($sitePhone) ?></p>
            <p><strong>Alamat:</strong> <?= nl2br(htmlspecialchars($siteAddress)) ?></p>
        </div>
    </div>
</div>
