<?php
require_once '../includes/functions.php';
session_start();

$cart = isset($_SESSION['cart']) ? $_SESSION['cart'] : [];
$total = 0;

foreach ($cart as $item) {
    $total += $item['price'] * $item['qty'];
}

if (isset($_POST['checkout'])) {
    header("Location: checkout.php");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Cart - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container">
    <h2>Keranjang Belanja</h2>
    <form method="POST">
        <table>
            <tr><th>Nama Produk</th><th>Qty</th><th>Harga</th><th>Subtotal</th></tr>
            <?php foreach ($cart as $id => $item): ?>
            <tr>
                <td><?= $item['name'] ?></td>
                <td><?= $item['qty'] ?></td>
                <td><?= rupiah($item['price']) ?></td>
                <td><?= rupiah($item['price'] * $item['qty']) ?></td>
            </tr>
            <?php endforeach; ?>
        </table>
        <p>Total: <?= rupiah($total) ?></p>
        <button name="checkout" class="btn btn-primary">Checkout</button>
    </form>
</div>
</body>
</html>
