<?php
$articles = $pdo->query("SELECT * FROM articles ORDER BY created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="site-container">
  <h2 class="section-title">Artikel Terbaru</h2>
  <div class="article-grid">
    <?php foreach($articles as $a): ?>
      <div class="article-card">
        <a href="index.php?page=article_detail&id=<?= $a['article_id'] ?>">
          <img src="<?= getProductImage($a['cover_image']) ?>">
          <div class="article-card-content">
            <h3><?= htmlspecialchars($a['title']) ?></h3>
            <p class="article-meta"><?= date('d M Y', strtotime($a['created_at'])) ?></p>
          </div>
        </a>
      </div>
    <?php endforeach; ?>
  </div>
</div>
