<?php
require_once __DIR__ . '/lib/vendor/autoload.php';
use Dompdf\Dompdf;

function generatePDF($html, $filename = 'document.pdf', $download = false, $watermarkText = '') {
    $dompdf = new Dompdf();
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();

    // Tambahkan watermark jika ada
    if ($watermarkText) {
        $canvas = $dompdf->getCanvas();
        $w = $canvas->get_width();
        $h = $canvas->get_height();
        $canvas->set_opacity(0.08); // Transparansi watermark
        $canvas->page_text(
            $w / 4,              // posisi X
            $h / 2,              // posisi Y
            $watermarkText,      // isi teks watermark
            null,                // font
            72,                  // ukuran font (large)
            array(0.85, 0.1, 0.1), // warna RGB (kemerahan)
            45,                  // rotasi
            0.5, 0.5             // scale X,Y
        );
    }

    if ($download && $filename) {
        $dompdf->stream($filename, ["Attachment" => true]);
    } elseif (!$download) {
        return $dompdf->output();
    }
}