<?php
$logo = getSetting('site_logo', $pdo);
$siteName = getSetting('site_name', $pdo);
$cartCount = isset($_SESSION['cart']) ? array_sum(array_column($_SESSION['cart'], 'qty')) : 0;

// Ambil kategori dari DB
$categories = $pdo->query("SELECT * FROM categories WHERE parent_id IS NULL ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?= isset($pageTitle) ? $pageTitle . " - " : "" ?><?= $siteName ?></title>
<link rel="stylesheet" href="<?= BASE_URL ?>/assets/css/style.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<style>
    body { font-family: 'Poppins', sans-serif; margin:0; }
    header, footer, .main-container { max-width:1200px; margin:auto; }
    .top-bar {
        display:flex; justify-content:space-between; align-items:center;
        padding:10px 0;
    }
    .logo img { height:40px; }
    .search-bar { flex:1; margin:0 20px; display:flex; }
    .search-bar input {
        flex:1; padding:8px 12px; border:1px solid #ddd; border-radius:4px 0 0 4px;
    }
    .search-bar button {
        background:#2D89EF; border:none; color:white; padding:0 15px;
        border-radius:0 4px 4px 0; cursor:pointer;
    }
    nav {
        background:#2D89EF; 
    }
    nav ul {
        max-width:1200px; margin:auto;
        list-style:none; padding:0;
        display:flex; flex-wrap:wrap;
    }
    nav li { position:relative; }
    nav li a {
        color:white; padding:12px 16px; display:block; text-decoration:none;
    }
    nav li:hover > a { background:rgba(255,255,255,0.15); }
    /* Dropdown */
    .dropdown-content {
        display:none; position:absolute; background:white; color:black;
        min-width:200px; box-shadow:0 4px 8px rgba(0,0,0,0.1);
        z-index:99;
    }
    .dropdown-content a {
        color:black; padding:10px 15px; text-decoration:none; display:block;
    }
    nav li:hover .dropdown-content { display:block; }
    /* Icons */
    .icons a { color:#333; margin-left:15px; text-decoration:none; position:relative; }
    .cart-count {
        position:absolute; top:-6px; right:-8px; background:red; color:white;
        font-size:10px; border-radius:50%; padding:2px 5px;
    }
    @media(max-width:768px){
        nav ul { flex-direction:column; display:none; }
        nav ul.active { display:flex; }
        .menu-toggle { display:block; color:white; padding:12px; cursor:pointer; }
    }
</style>
</head>
<body>

<header>
    <div class="top-bar">
        <div class="logo">
            <a href="<?= BASE_URL ?>/user/index.php">
                <?php if ($logo): ?>
                    <img src="<?= BASE_URL ?>/assets/img/<?= $logo ?>" alt="<?= $siteName ?>">
                <?php else: ?>
                    <strong><?= $siteName ?></strong>
                <?php endif; ?>
            </a>
        </div>
        <div class="search-bar">
            <input type="text" placeholder="Cari produk...">
            <button><i class="fa fa-search"></i></button>
        </div>
        <div class="icons">
            <a href="<?= BASE_URL ?>/user/index.php?page=cart"><i class="fa fa-shopping-cart"></i>
                <?php if ($cartCount > 0): ?><span class="cart-count"><?= $cartCount ?></span><?php endif; ?>
            </a>
            <?php if (!empty($_SESSION['user_id'])): ?>
                <a href="<?= BASE_URL ?>/user/index.php?page=dashboard"><i class="fa fa-user"></i></a>
                <a href="<?= BASE_URL ?>/user/index.php?page=logout"><i class="fa fa-sign-out-alt"></i></a>
            <?php else: ?>
                <a href="<?= BASE_URL ?>/user/index.php?page=login"><i class="fa fa-user"></i> Login</a>
            <?php endif; ?>
        </div>
    </div>
    <nav>
        <span class="menu-toggle" onclick="document.querySelector('nav ul').classList.toggle('active')">
            <i class="fa fa-bars"></i>
        </span>
        <ul>
            <li><a href="<?= BASE_URL ?>/user/index.php">Home</a></li>
            <li>
                <a href="#">Kategori <i class="fa fa-caret-down"></i></a>
                <div class="dropdown-content">
                    <?php foreach ($categories as $c): ?>
                        <a href="index.php?page=products&cat=<?= $c['category_id'] ?>"><?= htmlspecialchars($c['name']) ?></a>
                    <?php endforeach; ?>
                </div>
            </li>
            <li><a href="<?= BASE_URL ?>/user/index.php?page=articles">Artikel</a></li>
            <li><a href="<?= BASE_URL ?>/user/index.php?page=contact">Kontak</a></li>
        </ul>
    </nav>
</header>
