<?php

// Proteksi dan bersihkan input
function cleanInput($data) {
    return htmlspecialchars(strip_tags(trim($data)), ENT_QUOTES, 'UTF-8');
}

// Format harga ke Rupiah
function rupiah($angka) {
    return "Rp " . number_format($angka, 0, ',', '.');
}

// Generate affiliate code unik
function generateAffCode($length = 6) {
    return strtoupper(substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyz"), 0, $length));
}

// Recursive category builder
function getCategories($parent_id = null, $pdo, $level = 0) {
    $sql = "SELECT * FROM categories WHERE parent_id " . 
           ($parent_id === null ? "IS NULL" : "= :parent_id");
    $stmt = $pdo->prepare($sql);
    if ($parent_id !== null) {
        $stmt->bindValue(':parent_id', $parent_id, PDO::PARAM_INT);
    }
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($rows as $row) {
        echo str_repeat('--', $level) . ' ' . $row['name'] . "<br>";
        getCategories($row['category_id'], $pdo, $level + 1);
    }
}

// Set affiliate cookie
function setAffiliateCookie($aff_code) {
    setcookie('affiliate_code', $aff_code, time() + (3600 * 24 * 30), "/");
}

// Get affiliate ID dari cookie
function getAffiliateId($pdo) {
    if (!empty($_COOKIE['affiliate_code'])) {
        $stmt = $pdo->prepare("SELECT affiliate_id, parent_id FROM affiliate_tbl WHERE aff_code = ?");
        $stmt->execute([$_COOKIE['affiliate_code']]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }
    return null;
}

function generateWhatsAppLink($phone, $message) {
    // Hapus karakter non-digit
    $phone = preg_replace('/\D/', '', $phone);
    // Convert 08xxxx -> 628xxxx
    if (substr($phone, 0, 1) === '0') {
        $phone = '62' . substr($phone, 1);
    }
    return "https://wa.me/{$phone}?text=" . urlencode($message);
}


function getSetting($key, $pdo) {
    $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key=?");
    $stmt->execute([$key]);
    return $stmt->fetchColumn();
}

function setSetting($key, $value, $pdo) {
    $stmt = $pdo->prepare("REPLACE INTO settings (setting_key, setting_value) VALUES (?, ?)");
    return $stmt->execute([$key, $value]);
}

function getWhatsAppMessageByStatus($status, $customerName, $orderId, $pdo) {
    $site = SITE_NAME;
    $placeholders = [
        '{customer_name}' => $customerName,
        '{order_id}' => $orderId,
        '{site_name}' => $site
    ];
    $template = getSetting("wa_{$status}", $pdo);
    if (!$template) {
        $template = "Halo {$customerName}, status pesanan Anda (#{$orderId}) saat ini: {$status}.";
    }
    return str_replace(array_keys($placeholders), array_values($placeholders), $template);
}

function getWhatsAppShipmentMessage($customerName, $orderId, $courier, $resi) {
    return "Halo {$customerName}, pesanan Anda (#{$orderId}) telah dikirim.\nKurir: {$courier}\nNo Resi: {$resi}\nLacak di situs resmi kurir!";
}

function getWhatsAppDigitalMessage($customerName, $orderId, $link) {
    return "Halo {$customerName}, produk digital Anda untuk order #{$orderId} siap diunduh.\nDownload di sini: {$link}";
}
/**
 * Ambil data user dari order ID
 * @param int $orderId
 * @param PDO $pdo
 * @return array|null
 */
function getOrderUser($orderId, $pdo) {
    if (!$orderId) return null;

    $stmt = $pdo->prepare("
        SELECT u.name, u.email, u.phone, u.address 
        FROM orders o 
        JOIN user_tbl u ON o.user_id = u.user_id 
        WHERE o.order_id = ?
    ");
    $stmt->execute([$orderId]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user || empty($user['email'])) {
        error_log("getOrderUser: Email kosong atau user tidak ditemukan untuk order_id {$orderId}");
        return null;
    }

    return $user;
}
// Ambil kategori dan subkategori secara recursive dengan jumlah produk
function getCategoryTree($parent_id = null, $pdo, $level = 0) {
    $sql = "SELECT c.category_id, c.name,
                   (SELECT COUNT(p.product_id) FROM products p WHERE p.category_id = c.category_id) AS product_count,
                   (SELECT COUNT(*) FROM categories sc WHERE sc.parent_id = c.category_id) AS sub_count
            FROM categories c
            WHERE ";
    $sql .= ($parent_id === null) ? "c.parent_id IS NULL" : "c.parent_id = :pid";
    $sql .= " ORDER BY c.name ASC";

    $stmt = $pdo->prepare($sql);
    if ($parent_id === null) {
        $stmt->execute();
    } else {
        $stmt->execute(['pid' => $parent_id]);
    }
    $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($categories) {
        echo "<ul class='cat-level-$level'>";
        foreach ($categories as $cat) {
            $hasSub = $cat['sub_count'] > 0;

            echo "<li>";
            // Tombol expand/collapse
            if ($hasSub) {
                echo "<span class='toggle-btn' onclick='toggleSubCat(this)'>+</span> ";
            } else {
                echo "<span class='no-toggle'></span> ";
            }

            echo "<a href='index.php?page=products&cat={$cat['category_id']}'>" .
                 htmlspecialchars($cat['name']) . " <span class='count'>({$cat['product_count']})</span></a>";

            if ($hasSub) {
                echo "<div class='sub-cat' style='display:none;'>";
                getCategoryTree($cat['category_id'], $pdo, $level + 1);
                echo "</div>";
            }
            echo "</li>";
        }
        echo "</ul>";
    }
}

function getCategoryPath($category_id, $pdo) {
    $path = [];
    while ($category_id) {
        $stmt = $pdo->prepare("SELECT category_id, name, parent_id FROM categories WHERE category_id = ?");
        $stmt->execute([$category_id]);
        $cat = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($cat) {
            array_unshift($path, $cat['name']); // masukkan di awal array
            $category_id = $cat['parent_id'];
        } else {
            break;
        }
    }
    return implode(' > ', $path);
}

// Ambil path kategori dari root ke kategori sekarang
function getCategoryPathArray($category_id, $pdo) {
    $path = [];
    while ($category_id) {
        $stmt = $pdo->prepare("SELECT category_id, name, parent_id FROM categories WHERE category_id = ?");
        $stmt->execute([$category_id]);
        $cat = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($cat) {
            array_unshift($path, $cat); // masukin di depan array
            $category_id = $cat['parent_id'];
        } else {
            break;
        }
    }
    return $path;
}


function getProductImage($filename) {
    $pathRelative = 'assets/img/' . $filename;
    $pathAbsolute = __DIR__ . '/../' . $pathRelative;
    if (!empty($filename) && file_exists($pathAbsolute)) {
        return $pathRelative;
    }
    return 'assets/images/default.jpg';
}