<?php
function emailTemplatePaymentConfirm($order, $metode, $noKartu, $jumlah, $fileName) {
    $siteName = getSetting('site_name', $GLOBALS['pdo']);
    $primaryColor = "#2D89EF";
    $logo = getSetting('site_logo', $GLOBALS['pdo']);

    ob_start();
    ?>
    <div style="font-family: Arial, sans-serif; max-width:600px; margin:auto; border:1px solid #ddd; border-radius:8px; overflow:hidden;">
        <div style="background:<?= $primaryColor ?>; padding:15px; color:#fff; text-align:center;">
            <?php if($logo): ?>
                <img src="<?= BASE_URL ?>/assets/img/<?= $logo ?>" alt="<?= $siteName ?>" style="height:40px;">
            <?php else: ?>
                <h2 style="margin:0;"><?= $siteName ?></h2>
            <?php endif; ?>
        </div>
        <div style="padding:20px;">
            <h3 style="color:<?= $primaryColor ?>; margin-top:0;">Konfirmasi Pembayaran</h3>
            <p>Dear Admin, berikut konfirmasi pembayaran untuk order:</p>

            <h4>Data Order:</h4>
            <table style="width:100%; border-collapse:collapse;">
                <tr><td><strong>No Order</strong></td><td><?= $order['order_id'] ?></td></tr>
                <tr><td><strong>Tanggal Order</strong></td><td><?= $order['created_at'] ?></td></tr>
                <tr><td><strong>Nama Pembeli</strong></td><td><?= $order['name'] ?></td></tr>
                <tr><td><strong>Email</strong></td><td><?= $order['email'] ?></td></tr>
                <tr><td><strong>No Telp</strong></td><td><?= $order['phone'] ?></td></tr>
            </table>

            <h4 style="margin-top:20px;">Data Pembayaran:</h4>
            <table style="width:100%; border-collapse:collapse;">
                <tr><td><strong>Metode Pembayaran</strong></td><td><?= $metode ?></td></tr>
                <tr><td><strong>No CC/Debit</strong></td><td><?= $noKartu ?: '-' ?></td></tr>
                <tr><td><strong>Jumlah</strong></td><td><?= rupiah($jumlah) ?></td></tr>
                <tr><td><strong>Bukti Pembayaran</strong></td>
                    <td><a href="<?= BASE_URL ?>/user/uploads/payments/<?= $fileName ?>" style="color:<?= $primaryColor ?>;">Lihat Bukti</a></td>
                </tr>
            </table>
        </div>
        <div style="background:#f4f4f4; padding:10px; text-align:center; font-size:12px; color:#555;">
            Email ini dikirim secara otomatis dari sistem <?= $siteName ?>. Mohon jangan membalas email ini.
        </div>
    </div>
    <?php
    return ob_get_clean();
}


function emailTemplateDigitalConfirm($order, $produkList, $totalHarga) {
    $siteName = getSetting('site_name', $GLOBALS['pdo']);
    $primaryColor = "#2D89EF";
    $logo = getSetting('site_logo', $GLOBALS['pdo']);

    ob_start();
    ?>
    <div style="font-family: Arial, sans-serif; max-width:600px; margin:auto; border:1px solid #ddd; border-radius:8px; overflow:hidden;">
        <div style="background:<?= $primaryColor ?>; padding:15px; color:#fff; text-align:center;">
            <?php if($logo): ?>
                <img src="<?= BASE_URL ?>/assets/img/<?= $logo ?>" alt="<?= $siteName ?>" style="height:40px;">
            <?php else: ?>
                <h2 style="margin:0;"><?= $siteName ?></h2>
            <?php endif; ?>
        </div>
        <div style="padding:20px;">
            <h3 style="color:<?= $primaryColor ?>; margin-top:0;">Konfirmasi Penerimaan Produk Digital</h3>
            <p>Dear Admin, dengan ini saya mengkonfirmasi telah menerima produk digital yang saya beli:</p>

            <h4>Data Order:</h4>
            <table style="width:100%; border-collapse:collapse;">
                <tr><td><strong>No Order</strong></td><td><?= $order['order_id'] ?></td></tr>
            </table>

            <h4>Daftar Produk:</h4>
            <table style="width:100%; border-collapse:collapse;">
                <tr><th align="left">Nama Produk</th><th align="left">Qty</th></tr>
                <?php foreach ($produkList as $p): ?>
                <tr><td><?= $p['name'] ?></td><td><?= $p['qty'] ?></td></tr>
                <?php endforeach; ?>
            </table>

            <p><strong>Total Harga:</strong> <?= rupiah($totalHarga) ?></p>
            <p>Saya mengkonfirmasi dengan sebenarnya bahwa saya sudah menerima barang tersebut di atas.</p>
            <p><strong>Nama Pembeli:</strong> <?= $order['name'] ?></p>
        </div>
        <div style="background:#f4f4f4; padding:10px; text-align:center; font-size:12px; color:#555;">
            Email ini dikirim secara otomatis dari sistem <?= $siteName ?>. Mohon jangan membalas email ini.
        </div>
    </div>
    <?php
    return ob_get_clean();
}
