<?php
require_once '../includes/db.php';
require_once '../includes/aff_auth.php';

$affId = $_SESSION['affiliate_id'];
$msg = "";

// Request payout hanya jika ada unpaid commission > 0
if (isset($_POST['request_payout'])) {
    $unpaid = $pdo->prepare("SELECT SUM(amount) FROM affiliate_commissions WHERE affiliate_id=? AND status='unpaid'");
    $unpaid->execute([$affId]);
    $unpaid = $unpaid->fetchColumn() ?: 0;

    if ($unpaid > 0) {
        $pdo->prepare("UPDATE affiliate_commissions SET status='paid' WHERE affiliate_id=? AND status='unpaid'")->execute([$affId]);
        $msg = "Payout request berhasil diajukan, admin akan memproses.";
    } else {
        $msg = "Tidak ada komisi yang bisa dicairkan.";
    }
}

$paidHistory = $pdo->prepare("SELECT * FROM affiliate_commissions WHERE affiliate_id=? AND status='paid' ORDER BY created_at DESC");
$paidHistory->execute([$affId]);
$history = $paidHistory->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Payouts - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container">
    <h2>Payouts</h2>
    <form method="POST">
        <button class="btn btn-success" name="request_payout">Request Payout</button>
    </form>
    <p><?= $msg ?></p>
    <h3>Riwayat Payout</h3>
    <table>
        <tr><th>Komisi ID</th><th>Level</th><th>Amount</th><th>Tanggal Dibayar</th></tr>
        <?php foreach ($history as $h): ?>
        <tr>
            <td><?= $h['commission_id'] ?></td>
            <td><?= $h['level'] ?></td>
            <td><?= rupiah($h['amount']) ?></td>
            <td><?= $h['created_at'] ?></td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>
</body>
</html>
