<?php
require_once '../includes/db.php';
require_once '../includes/aff_auth.php';

$affId = $_SESSION['affiliate_id'];
$commissions = $pdo->prepare("SELECT ac.*, o.created_at AS order_date, o.total_price 
                              FROM affiliate_commissions ac
                              JOIN orders o ON ac.order_id = o.order_id
                              WHERE ac.affiliate_id=? ORDER BY ac.created_at DESC");
$commissions->execute([$affId]);
$data = $commissions->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Commissions - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container">
    <h2>Data Komisi</h2>
    <table>
        <tr><th>Tanggal Order</th><th>Level</th><th>Order Total</th><th>Komisi</th><th>Status</th></tr>
        <?php foreach ($data as $c): ?>
        <tr>
            <td><?= $c['order_date'] ?></td>
            <td><?= $c['level'] ?></td>
            <td><?= rupiah($c['total_price']) ?></td>
            <td><?= rupiah($c['amount']) ?></td>
            <td><?= ucfirst($c['status']) ?></td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>
</body>
</html>
