<?php
$primaryColor = "#2D89EF";
$siteName = getSetting('site_name', $pdo);
$siteLogo = getSetting('site_logo', $pdo);
$siteEmail = getSetting('site_email', $pdo);
$siteAddress = getSetting('site_address', $pdo);
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<style>
    body { font-family: DejaVu Sans, sans-serif; font-size: 12px; margin:0; padding:0; }
    header { padding:10px 0; border-bottom:2px solid <?= $primaryColor ?>; display:flex; align-items:center; }
    header img { height:50px; margin-right:15px; }
    .site-title { font-size:20px; font-weight:bold; color:<?= $primaryColor ?>; }
    footer { position:fixed; bottom:0; left:0; right:0; border-top:1px solid #ccc; padding:5px; text-align:center; font-size:10px; }
    h1, h2, h3 { color:<?= $primaryColor ?>; margin-bottom:5px; }
    table { border-collapse:collapse; width:100%; margin-top:10px; }
    table th, table td { border:1px solid #ccc; padding:6px; text-align:left; }
    table th { background:<?= $primaryColor ?>; color:white; }
    .info-box { margin-top:10px; }
    .info-title { font-weight:bold; margin-bottom:3px; }
</style>
</head>
<body>

<header>
    <?php if ($siteLogo): ?>
        <img src="<?= BASE_URL ?>/assets/img/<?= $siteLogo ?>" alt="logo">
    <?php endif; ?>
    <div>
        <div class="site-title"><?= $siteName ?></div>
        <div style="font-size:11px;"><?= $siteEmail ?></div>
    </div>
</header>

<div class="content">
