<?php
require_once '../includes/db.php';
require_once '../includes/admin_auth.php';

$orderId = (int)$_GET['id'];

$msg = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_id = (int)$_POST['product_id'];
    $resi = cleanInput($_POST['tracking_no']);
    $courier = cleanInput($_POST['courier']);

    $stmt = $pdo->prepare("INSERT INTO shipments (product_id, order_id, tracking_no, courier) VALUES (?, ?, ?, ?)");
    $stmt->execute([$product_id, $orderId, $resi, $courier]);

    // Update status order
    $pdo->prepare("UPDATE orders SET status='shipped' WHERE order_id=?")->execute([$orderId]);

    $msg = "Resi pengiriman berhasil disimpan.";
    // Kirim WA ke customer
$stmtUser = $pdo->prepare("SELECT u.name, u.phone FROM orders o JOIN user_tbl u ON o.user_id=u.user_id WHERE o.order_id=?");
$stmtUser->execute([$orderId]);
$user = $stmtUser->fetch(PDO::FETCH_ASSOC);

$waMsg = getWhatsAppShipmentMessage($user['name'], $orderId, $courier, $resi);
$waLink = generateWhatsAppLink($user['phone'], $waMsg);

// Redirect ke WA
header("Location: {$waLink}");
exit;

}


// Ambil email user
$userStmt = $pdo->prepare("SELECT u.name, u.email FROM orders o JOIN user_tbl u ON o.user_id=u.user_id WHERE o.order_id=?");
$userStmt->execute([$orderId]);
$user = $userStmt->fetch(PDO::FETCH_ASSOC);

// Kirim email notifikasi
require_once '../includes/mailer.php';
$resiHTML = "<p>Pesanan Anda telah dikirim:</p>
<ul>
<li>Kurir: {$courier}</li>
<li>No Resi: {$resi}</li>
</ul>
<p>Anda dapat melacak pengiriman melalui situs resmi kurir.</p>";

sendEmail($user['email'], $user['name'], "Pesanan Anda Dikirim - Order #$orderId", $resiHTML);






$items = $pdo->prepare("SELECT oi.*, p.name FROM order_items oi JOIN products p ON oi.product_id=p.product_id WHERE oi.order_id=? AND p.type='non-digital'");
$items->execute([$orderId]);
$physicalItems = $items->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Kirim Produk Non-Digital - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container">
    <h2>Kirim Produk Non-Digital (Order #<?= $orderId ?>)</h2>
    <?php if ($msg): ?><div class="card"><?= $msg ?></div><?php endif; ?>
    <form method="POST">
        <label>Pilih Produk</label>
        <select name="product_id" required>
            <?php foreach ($physicalItems as $p): ?>
            <option value="<?= $p['product_id'] ?>"><?= $p['name'] ?></option>
            <?php endforeach; ?>
        </select>
        <label>No Resi</label>
        <input type="text" name="tracking_no" required>
        <label>Kurir</label>
        <input type="text" name="courier" required>
        <button type="submit" class="btn btn-success">Simpan</button>
    </form>
</div>
</body>
</html>
