<?php
require_once '../includes/db.php';
require_once '../includes/config.php';
require_once '../includes/admin_auth.php';
require_once '../includes/functions.php';

$orderId = (int)$_GET['id'];
$msg = "";

// Ambil produk digital di order
$items = $pdo->prepare("
    SELECT oi.product_id, p.name 
    FROM order_items oi
    JOIN products p ON oi.product_id = p.product_id
    WHERE oi.order_id=? AND p.type='digital'
");
$items->execute([$orderId]);
$digitalItems = $items->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_id = (int)$_POST['product_id'];
    $pesan_email = trim($_POST['email_message']);
    $filePath = '';
    $originalName = '';

    // Upload file digital
    if (!empty($_FILES['digital_file']['name']) && $_FILES['digital_file']['error'] === UPLOAD_ERR_OK) {
        $allowedExt = ['zip', 'pdf', 'epub', 'mp4', 'mp3'];
        $fileExt = strtolower(pathinfo($_FILES['digital_file']['name'], PATHINFO_EXTENSION));

        if (in_array($fileExt, $allowedExt)) {
            $uploadDir = __DIR__ . '/../uploads/temp_email/';
            if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

            $originalName = basename($_FILES['digital_file']['name']);
            $fileName = time() . "_" . preg_replace('/[^a-zA-Z0-9_\.-]/', '_', $originalName);
            $filePath = $uploadDir . $fileName;

            move_uploaded_file($_FILES['digital_file']['tmp_name'], $filePath);
        } else {
            $msg = "❌ Format file tidak diizinkan.";
        }
    }

    if ($filePath) {
        // Update status order
        $pdo->prepare("UPDATE orders SET status='delivered' WHERE order_id=?")->execute([$orderId]);

        // Ambil data user dengan helper
        $user = getOrderUser($orderId, $pdo);
        if (!$user) {
            $msg = "❌ Email user tidak ditemukan, kirim gagal.";
        } else {
            // Ambil detail order untuk dimasukkan ke email
            $orderStmt = $pdo->prepare("
                SELECT oi.qty, p.name, oi.price 
                FROM order_items oi
                JOIN products p ON oi.product_id=p.product_id
                WHERE oi.order_id=?
            ");
            $orderStmt->execute([$orderId]);
            $orderItems = $orderStmt->fetchAll(PDO::FETCH_ASSOC);

            $orderTable = "<table border='1' cellpadding='6' cellspacing='0' style='border-collapse:collapse;width:100%;'>
                <tr><th>Produk</th><th>Qty</th><th>Harga</th><th>Subtotal</th></tr>";
            $total = 0;
            foreach ($orderItems as $item) {
                $subtotal = $item['qty'] * $item['price'];
                $total += $subtotal;
                $orderTable .= "<tr>
                    <td>{$item['name']}</td>
                    <td>{$item['qty']}</td>
                    <td>" . rupiah($item['price']) . "</td>
                    <td>" . rupiah($subtotal) . "</td>
                </tr>";
            }
            $orderTable .= "<tr><td colspan='3' align='right'><strong>Total</strong></td>
                <td><strong>" . rupiah($total) . "</strong></td></tr></table>";

            // Kirim email dengan attachment
            require_once '../includes/mailer.php';
            $body = "
                <p>Halo {$user['name']},</p>
                <p>Produk digital Anda untuk Order <strong>#{$orderId}</strong> sudah kami kirim. File terlampir dalam email ini.</p>
                {$orderTable}
                <p><em>Pesan dari Admin:</em> {$pesan_email}</p>
                <p>Terima kasih telah berbelanja di <strong>" . SITE_NAME . "</strong>.</p>
            ";

            sendEmailWithAttachment(
                $user['email'],
                $user['name'],
                "Produk Digital Anda - Order #{$orderId}",
                $body,
                $filePath,
                $originalName
            );

            // Hapus file sementara
            @unlink($filePath);

            $msg = "✅ Produk digital berhasil dikirim via email.";
        }
    } else {
        if (!$msg) {
            $msg = "⚠ Harap upload file digital.";
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Kirim Produk Digital - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container">
    <h2>Kirim Produk Digital (Order #<?= $orderId ?>)</h2>
    <?php if ($msg): ?><div class="card-info"><?= $msg ?></div><?php endif; ?>

    <form method="POST" enctype="multipart/form-data">
        <label>Pilih Produk Digital</label>
        <select name="product_id" required>
            <option value="">--Pilih Produk--</option>
            <?php foreach ($digitalItems as $d): ?>
                <option value="<?= $d['product_id'] ?>"><?= $d['name'] ?></option>
            <?php endforeach; ?>
        </select>

        <label>Pesan Email (opsional)</label>
        <textarea name="email_message" placeholder="Keterangan tambahan untuk pembeli..."></textarea>

        <label>Upload File Digital</label>
        <input type="file" name="digital_file" accept=".zip,.pdf,.epub,.mp4,.mp3" required>

        <button type="submit" class="btn btn-success">Kirim via Email</button>
    </form>
</div>
</body>
</html>
