<?php
require_once '../includes/db.php';
require_once '../includes/admin_auth.php';

$msg = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = cleanInput($_POST['name']);
    $category_id = $_POST['category_id'];
    $type = $_POST['type'];
    $description = $_POST['description'];
    $price = $_POST['price'];
    $stock = $_POST['stock'];
    $image = "";

    if (!empty($_FILES['image']['name'])) {
        $image = time() . "_" . basename($_FILES['image']['name']);
        move_uploaded_file($_FILES['image']['tmp_name'], "../assets/img/" . $image);
    }

    $stmt = $pdo->prepare("INSERT INTO products (category_id, name, type, description, price, stock, image) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$category_id, $name, $type, $description, $price, $stock, $image]);
    $msg = "Produk berhasil ditambahkan";
}

$categories = $pdo->query("SELECT * FROM categories ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
$products = $pdo->query("SELECT p.*, c.name AS category_name FROM products p JOIN categories c ON p.category_id = c.category_id ORDER BY p.product_id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Products - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container">
    <h2>Kelola Produk</h2>
    <form method="POST" enctype="multipart/form-data">
        <input type="text" name="name" placeholder="Nama Produk" required>
        <select name="category_id" required>
            <option value="">-- Pilih Kategori --</option>
            <?php foreach ($categories as $c): ?>
            <option value="<?= $c['category_id'] ?>"><?= $c['name'] ?></option>
            <?php endforeach; ?>
        </select>
        <select name="type" required>
            <option value="digital">Digital</option>
            <option value="non-digital">Non-Digital</option>
        </select>
        <textarea name="description" placeholder="Deskripsi"></textarea>
        <input type="number" name="price" placeholder="Harga" required>
        <input type="number" name="stock" placeholder="Stok" required>
        <input type="file" name="image" required>
        <button class="btn btn-primary" type="submit">Tambah</button>
    </form>
    <p><?= $msg ?></p>
    <hr>
    <table>
        <tr><th>Produk</th><th>Kategori</th><th>Harga</th><th>Stok</th></tr>
        <?php foreach ($products as $p): ?>
        <tr>
            <td><?= $p['name'] ?></td>
            <td><?= $p['category_name'] ?></td>
            <td><?= rupiah($p['price']) ?></td>
            <td><?= $p['stock'] ?></td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>
</body>
</html>
