<?php
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/pdf_helper.php';

$orderId = (int)$_GET['id'];

// Ambil data order dan user
$stmt = $pdo->prepare("SELECT o.*, u.name, u.email, u.phone, u.address 
    FROM orders o JOIN user_tbl u ON o.user_id=u.user_id WHERE o.order_id=?");
$stmt->execute([$orderId]);
$order = $stmt->fetch();

$items = $pdo->prepare("SELECT oi.*, p.name FROM order_items oi 
    JOIN products p ON oi.product_id=p.product_id WHERE oi.order_id=?");
$items->execute([$orderId]);
$orderItems = $items->fetchAll();

ob_start();
?>
<h2>PURCHASE ORDER</h2>
<p>No Order: <?= $order['order_id'] ?><br>
Tanggal Order: <?= $order['created_at'] ?></p>

<h3>Data Pembeli</h3>
<p><?= $order['name'] ?><br>
<?= $order['address'] ?><br>
Email: <?= $order['email'] ?><br>
Telp: <?= $order['phone'] ?></p>

<h3>Detail Pesanan</h3>
<table border="1" width="100%" cellspacing="0" cellpadding="5">
<tr>
    <th>Produk</th><th>Qty</th><th>Harga</th><th>Subtotal</th>
</tr>
<?php foreach($orderItems as $i): ?>
<tr>
    <td><?= $i['name'] ?></td>
    <td><?= $i['qty'] ?></td>
    <td><?= rupiah($i['price']) ?></td>
    <td><?= rupiah($i['qty'] * $i['price']) ?></td>
</tr>
<?php endforeach; ?>
</table>
<?php
$html = ob_get_clean();
generatePDF($html, "order_{$orderId}.pdf");