<?php
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/pdf_helper.php';

$orderId = (int)($_GET['id'] ?? 0);
if (!$orderId) die("ID Order tidak valid");

// Get data umum order
$stmt = $pdo->prepare("SELECT o.*, u.name, u.email, u.phone, u.address 
    FROM orders o 
    JOIN user_tbl u ON o.user_id=u.user_id 
    WHERE o.order_id=?");
$stmt->execute([$orderId]);
$order = $stmt->fetch();

if (!$order) die("Order tidak ditemukan.");

// Get detail item
$stmtItems = $pdo->prepare("SELECT oi.*, p.name FROM order_items oi 
    JOIN products p ON oi.product_id=p.product_id 
    WHERE oi.order_id=?");
$stmtItems->execute([$orderId]);
$orderItems = $stmtItems->fetchAll();

$total = array_sum(array_map(fn($i) => $i['qty'] * $i['price'], $orderItems));


$status = strtoupper($order['status']);
$watermarkMap = [
    'PAID'      => 'PAID',
    'PENDING'   => 'PENDING PAYMENT',
    'SHIPPED'   => 'SHIPPED',
    'DELIVERED' => 'DELIVERED',
    'CANCELLED' => 'CANCELLED'
];
$watermarkText = $watermarkMap[$status] ?? '';





// Folder sementara
$tempDir = __DIR__ . '/temp_pdf/' . $orderId;
if (!is_dir($tempDir)) mkdir($tempDir, 0777, true);

// Helper simpan PDF keren
function savePDF($html, $path, $watermarkText) {
    $pdfOutput = generatePDF($html, '', false, $watermarkText);
    file_put_contents($path, $pdfOutput);
}


// 1. Purchase Order
ob_start();
include __DIR__ . '/templates/pdf_order_template.php';
$html = ob_get_clean();
savePDF($html, "$tempDir/purchase_order.pdf", $watermarkText);

// 2. Invoice
ob_start();
include __DIR__ . '/templates/pdf_invoice_template.php';
$html = ob_get_clean();
savePDF($html, "$tempDir/invoice.pdf", $watermarkText);

// 3. Konfirmasi Pembayaran
ob_start();
include __DIR__ . '/templates/pdf_payment_confirm_template.php';
$html = ob_get_clean();
savePDF($html, "$tempDir/payment_confirmation.pdf", $watermarkText);

// 4. Konfirmasi Produk Diterima
ob_start();
include __DIR__ . '/templates/pdf_product_received_template.php';
$html = ob_get_clean();
savePDF($html, "$tempDir/product_received.pdf", $watermarkText);
// 5. Bukti Pembayaran
$proofFile = $order['payment_proof'] ?? null;
ob_start();
include __DIR__ . '/templates/pdf_payment_proof_template.php';
$html = ob_get_clean();
savePDF($html, "$tempDir/payment_proof.pdf", $watermarkText);
// Buat ZIP
$zipFile = __DIR__ . "/temp_pdf/order_{$orderId}_docs.zip";
$zip = new ZipArchive();
if ($zip->open($zipFile, ZipArchive::CREATE | ZipArchive::OVERWRITE) === TRUE) {
    $files = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($tempDir),
        RecursiveIteratorIterator::LEAVES_ONLY
    );
    foreach ($files as $file) {
        if (!$file->isDir()) {
            $filePath = $file->getRealPath();
            $relativePath = substr($filePath, strlen($tempDir) + 1);
            $zip->addFile($filePath, $relativePath);
        }
    }
    $zip->close();
}

// Kirim ZIP ke browser
header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="' . basename($zipFile) . '"');
header('Content-Length: ' . filesize($zipFile));
readfile($zipFile);

// Bersihkan sementara
array_map('unlink', glob("$tempDir/*"));
rmdir($tempDir);
unlink($zipFile);
exit;