<?php
require_once '../includes/db.php';
require_once '../includes/admin_auth.php';

// Mark as paid
if (isset($_GET['pay_id'])) {
    $id = (int)$_GET['pay_id'];
    $pdo->prepare("UPDATE affiliate_commissions SET status='paid' WHERE commission_id=?")->execute([$id]);
}

$commissions = $pdo->query("SELECT ac.*, a.name AS affiliate_name 
                            FROM affiliate_commissions ac 
                            JOIN affiliate_tbl a ON ac.affiliate_id = a.affiliate_id
                            WHERE ac.status='unpaid'
                            ORDER BY ac.created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Payouts - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container">
    <h2>Affiliate Payouts</h2>
    <table>
        <tr><th>ID</th><th>Affiliate</th><th>Level</th><th>Amount</th><th>Aksi</th></tr>
        <?php foreach ($commissions as $c): ?>
        <tr>
            <td><?= $c['commission_id'] ?></td>
            <td><?= $c['affiliate_name'] ?></td>
            <td><?= $c['level'] ?></td>
            <td><?= rupiah($c['amount']) ?></td>
            <td><a href="?pay_id=<?= $c['commission_id'] ?>" class="btn btn-success">Mark Paid</a></td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>
</body>
</html>
