<?php
require_once '../includes/db.php';
require_once '../includes/config.php';
require_once '../includes/admin_auth.php';
require_once '../includes/functions.php';

$payments = $pdo->query("
    SELECT o.*, u.name AS customer, u.phone, u.email
    FROM orders o
    JOIN user_tbl u ON o.user_id = u.user_id
    WHERE o.payment_proof IS NOT NULL
    ORDER BY o.created_at DESC
")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Konfirmasi Pembayaran - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container">
    <h2>Daftar Konfirmasi Pembayaran</h2>
    <table>
        <tr>
            <th>No Order</th>
            <th>Customer</th>
            <th>Metode</th>
            <th>Jumlah</th>
            <th>Bukti</th>
            <th>Status</th>
            <th>Aksi</th>
        </tr>
        <?php foreach ($payments as $p): ?>
        <tr>
            <td>#<?= $p['order_id'] ?></td>
            <td><?= $p['customer'] ?></td>
            <td><?= $p['payment_method'] ?></td>
            <td><?= rupiah($p['payment_amount']) ?></td>
            <td>
                <?php if ($p['payment_proof']): ?>
                    <a href="../user/uploads/payments/<?= $p['payment_proof'] ?>" target="_blank">Lihat</a>
                <?php endif; ?>
            </td>
            <td><?= ucfirst($p['status']) ?></td>
            <td>
                <?php if ($p['status'] === 'pending'): ?>
                    <a href="payments_list.php?approve=<?= $p['order_id'] ?>" class="btn btn-success">Approve</a>
                <?php endif; ?>
            </td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>
</body>
</html>
<?php
// Approve action
if (isset($_GET['approve'])) {
    $oid = (int)$_GET['approve'];
    $pdo->prepare("UPDATE orders SET status='paid' WHERE order_id=?")->execute([$oid]);
    header("Location: payments_list.php");
    exit;
}
?>