<?php
require_once '../includes/db.php';
require_once '../includes/config.php';
require_once '../includes/admin_auth.php';
require_once '../includes/functions.php';

$invoices = $pdo->query("
    SELECT o.*, u.name AS customer
    FROM orders o
    JOIN user_tbl u ON o.user_id = u.user_id
    WHERE o.status IN ('paid','shipped','delivered')
    ORDER BY o.created_at DESC
")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Daftar Invoice - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container">
    <h2>Daftar Invoice</h2>
    <table>
        <tr><th>No Invoice</th><th>Customer</th><th>Total</th><th>Status</th><th>PDF</th></tr>
        <?php foreach ($invoices as $inv): ?>
        <tr>
            <td>#<?= $inv['order_id'] ?></td>
            <td><?= $inv['customer'] ?></td>
            <td><?= rupiah($inv['total_price']) ?></td>
            <td><?= ucfirst($inv['status']) ?></td>
            <td><a href="pdf_invoice.php?id=<?= $inv['order_id'] ?>" target="_blank">Cetak</a></td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>
</body>
</html>
