<?php

require_once '../includes/db.php';
require_once '../includes/functions.php';
require_once '../includes/admin_auth.php';

$msg = "";
// Tambah artikel
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = cleanInput($_POST['title']);
    $content = $_POST['content'];
    $stmt = $pdo->prepare("INSERT INTO articles (title, content, admin_id) VALUES (?, ?, ?)");
    $stmt->execute([$title, $content, $_SESSION['admin_id']]);
    $msg = "Artikel berhasil ditambahkan";
}

$articles = $pdo->query("SELECT * FROM articles ORDER BY created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Articles - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container">
    <h2>Kelola Artikel</h2>
    <form method="POST">
        <input type="text" name="title" placeholder="Judul Artikel" required>
        <textarea name="content" placeholder="Isi Artikel" required></textarea>
        <button class="btn btn-primary" type="submit">Tambah</button>
    </form>
    <p><?= $msg ?></p>
    <hr>
    <table>
        <tr><th>ID</th><th>Judul</th><th>Tanggal</th></tr>
        <?php foreach($articles as $art): ?>
        <tr>
            <td><?= $art['article_id'] ?></td>
            <td><?= $art['title'] ?></td>
            <td><?= $art['created_at'] ?></td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>
</body>
</html>
