<?php
require_once '../includes/db.php';
require_once '../includes/functions.php';

session_start();

$msg = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = cleanInput($_POST['email']);
    $password = $_POST['password'];

    $stmt = $pdo->prepare("SELECT * FROM user_tbl WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['user_id'];
        header("Location: index.php?page=dashboard");
        exit;
    } else {
        $msg = "Email atau password salah.";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Login - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container">
    <h2>Login</h2>
    <form method="POST">
        <input type="email" name="email" placeholder="Email" required>
        <input type="password" name="password" placeholder="Password" required>
        <button class="btn btn-primary" type="submit">Login</button>
    </form>
    <p><?= $msg ?></p>
</div>
</body>
</html>
