<?php
require_once '../includes/db.php';
require_once '../includes/config.php';
require_once '../includes/admin_auth.php';
require_once '../includes/functions.php';

// Ambil order delivered
$received = $pdo->query("
    SELECT o.*, u.name AS customer
    FROM orders o
    JOIN user_tbl u ON o.user_id = u.user_id
    WHERE o.status = 'delivered'
    ORDER BY o.updated_at DESC
")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Konfirmasi Produk Diterima - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container">
    <h2>Daftar Konfirmasi Produk Diterima</h2>
    <table>
        <tr><th>No Order</th><th>Customer</th><th>Tanggal Diterima</th></tr>
        <?php foreach ($received as $r): ?>
        <tr>
            <td>#<?= $r['order_id'] ?></td>
            <td><?= $r['customer'] ?></td>
            <td><?= $r['updated_at'] ?></td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>
</body>
</html>
