<?php
require_once '../includes/db.php';
require_once '../includes/admin_auth.php';

$id = (int)$_GET['id'];
$stmt = $pdo->prepare("SELECT o.*, u.name AS customer, u.email 
                       FROM orders o 
                       JOIN user_tbl u ON o.user_id = u.user_id 
                       WHERE o.order_id = ?");
$stmt->execute([$id]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$order) die("Order tidak ditemukan");

// Ambil detail items
$stmtItems = $pdo->prepare("SELECT oi.*, p.name FROM order_items oi 
                            JOIN products p ON oi.product_id = p.product_id
                            WHERE oi.order_id = ?");
$stmtItems->execute([$id]);
$items = $stmtItems->fetchAll(PDO::FETCH_ASSOC);

// Update status
if (isset($_POST['update_status'])) {
    $status = $_POST['status'];
    $pdo->prepare("UPDATE orders SET status=? WHERE order_id=?")->execute([$status, $id]);
    header("Location: orders.php");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Order Detail - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container">
    <h2>Order #<?= $order['order_id'] ?> - <?= $order['customer'] ?></h2>
    <p>Email: <?= $order['email'] ?></p>
<?php
$waMessage = getWhatsAppMessageByStatus($order['status'], $order['customer'], $order['order_id'], $pdo);
$waLink = generateWhatsAppLink($order['phone'] ?? '', $waMessage);
?>
<p>No HP: <?= $order['phone'] ?? '-' ?> |
<a href="<?= $waLink ?>" target="_blank" class="btn btn-success">Kirim WhatsApp</a></p>



    <h3>Items</h3>
    <ul>
    <?php foreach ($items as $it): ?>
        <li><?= $it['name'] ?> x <?= $it['qty'] ?> - <?= rupiah($it['price']) ?></li>
    <?php endforeach; ?>
    </ul>

    <h3>Update Status</h3>
    <form method="POST">
        <select name="status">
            <option value="pending" <?= $order['status']=='pending'?'selected':''?>>Pending</option>
            <option value="paid" <?= $order['status']=='paid'?'selected':''?>>Paid</option>
            <option value="shipped" <?= $order['status']=='shipped'?'selected':''?>>Shipped</option>
            <option value="delivered" <?= $order['status']=='delivered'?'selected':''?>>Delivered</option>
            <option value="cancelled" <?= $order['status']=='cancelled'?'selected':''?>>Cancelled</option>
        </select>
        <button type="submit" name="update_status" class="btn btn-success">Update</button>
    </form>
</div>
</body>
</html>
