<?php
require_once '../includes/db.php';
require_once '../includes/config.php';
require_once '../includes/admin_auth.php';
require_once '../includes/functions.php';

$incoming = $pdo->query("
    SELECT o.*, u.name AS customer
    FROM orders o
    JOIN user_tbl u ON o.user_id = u.user_id
    WHERE o.status IN ('pending', 'paid')
    ORDER BY o.created_at DESC
")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Order Masuk - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container">
    <h2>Order Masuk</h2>
    <table>
        <tr><th>No Order</th><th>Customer</th><th>Total</th><th>Status</th></tr>
        <?php foreach ($incoming as $in): ?>
        <tr>
            <td>#<?= $in['order_id'] ?></td>
            <td><?= $in['customer'] ?></td>
            <td><?= rupiah($in['total_price']) ?></td>
            <td><?= ucfirst($in['status']) ?></td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>
</body>
</html>
