<?php
require_once '../includes/db.php';
require_once '../includes/config.php';
require_once '../includes/admin_auth.php';
require_once '../includes/functions.php';

// Ambil semua order digital yang status delivered
$orders = $pdo->query("
    SELECT DISTINCT o.order_id, o.created_at, o.status, u.name AS customer
    FROM orders o
    JOIN user_tbl u ON o.user_id = u.user_id
    JOIN order_items oi ON o.order_id = oi.order_id
    JOIN products p ON oi.product_id = p.product_id
    WHERE o.status = 'delivered' AND p.type = 'digital'
    ORDER BY o.created_at DESC
")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Kirim Ulang Produk Digital - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container">
    <h2>📦 Kirim Ulang Produk Digital</h2>
    <p>Daftar order produk digital yang sudah dikirim, klik “Kirim Ulang” untuk mengirim kembali kepada pelanggan.</p>

    <table>
        <tr>
            <th>ID</th>
            <th>Tanggal</th>
            <th>Customer</th>
            <th>Status</th>
            <th>Aksi</th>
        </tr>
        <?php if (count($orders) > 0): ?>
            <?php foreach ($orders as $o): ?>
            <tr>
                <td>#<?= $o['order_id'] ?></td>
                <td><?= $o['created_at'] ?></td>
                <td><?= $o['customer'] ?></td>
                <td><?= ucfirst($o['status']) ?></td>
                <td>
                    <a href="send_digital.php?id=<?= $o['order_id'] ?>" class="btn btn-warning">Kirim Ulang</a>
                    <a href="order_detail.php?id=<?= $o['order_id'] ?>" class="btn btn-primary">Detail Order</a>
                </td>
            </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr><td colspan="5" style="text-align:center;">Tidak ada order digital yang siap untuk dikirim ulang.</td></tr>
        <?php endif; ?>
    </table>
</div>
</body>
</html>
