<?php
$id = (int)($_GET['id'] ?? 0);
$stmt = $pdo->prepare("SELECT * FROM articles WHERE article_id=? LIMIT 1");
$stmt->execute([$id]);
$article = $stmt->fetch(PDO::FETCH_ASSOC);
$otherArticles = $pdo->prepare("SELECT article_id, title, created_at, cover_image FROM articles WHERE article_id<>? ORDER BY created_at DESC LIMIT 10");
$otherArticles->execute([$id]);
$otherArticles = $otherArticles->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="site-container layout-2col">
  <div class="main">
    <h1><?= htmlspecialchars($article['title']) ?></h1>
    <p class="article-meta"><?= date('d M Y', strtotime($article['created_at'])) ?></p>
    <img src="../../<?= getProductImage($article['cover_image']) ?>">
    <div><?= nl2br($article['content']) ?></div>
  </div>
  <div class="sidebar">
    <h3>Artikel Lainnya</h3>
    <ul class="article-list-sidebar">
      <?php foreach($otherArticles as $oa): ?>
        <li>
          <img src="../../<?= getProductImage($oa['cover_image']) ?>">
          <div>
            <a class="title" href="index.php?page=article_detail&id=<?= $oa['article_id'] ?>">
              <?= htmlspecialchars($oa['title']) ?>
            </a>
            <small><?= date('d M Y', strtotime($oa['created_at'])) ?></small>
          </div>
        </li>
      <?php endforeach; ?>
    </ul>
  </div>
</div>
