<?php
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/pdf_helper.php';

$orderId = (int)$_GET['id'];

$stmt = $pdo->prepare("SELECT o.*, u.name, u.email, u.phone 
    FROM orders o JOIN user_tbl u ON o.user_id=u.user_id WHERE o.order_id=?");
$stmt->execute([$orderId]);
$order = $stmt->fetch();

$stmtItems = $pdo->prepare("SELECT oi.*, p.name FROM order_items oi 
    JOIN products p ON oi.product_id=p.product_id WHERE oi.order_id=?");
$stmtItems->execute([$orderId]);
$items = $stmtItems->fetchAll();
$total = array_sum(array_map(fn($i) => $i['qty']*$i['price'], $items));

ob_start();
?>
<h2>KONFIRMASI PRODUK DITERIMA</h2>
<p>No Order: <?= $order['order_id'] ?><br>
Tanggal Order: <?= $order['created_at'] ?></p>

<h3>Daftar Produk</h3>
<table border="1" width="100%" cellspacing="0" cellpadding="5">
<tr><th>Produk</th><th>Qty</th></tr>
<?php foreach($items as $i): ?>
<tr><td><?= $i['name'] ?></td><td><?= $i['qty'] ?></td></tr>
<?php endforeach; ?>
<tr><td colspan="2"><strong>Total: <?= rupiah($total) ?></strong></td></tr>
</table>

<p>Saya menyatakan barang di atas sudah saya terima dengan baik.</p>
<p>Nama Pembeli: <?= $order['name'] ?></p>
<?php
$html = ob_get_clean();
generatePDF($html, "product_received_{$orderId}.pdf");