<?php
require_once '../includes/db.php';
require_once '../includes/admin_auth.php';

if (isset($_GET['approve'])) {
    $oid = (int)$_GET['approve'];
    $pdo->prepare("UPDATE orders SET status='paid' WHERE order_id=?")->execute([$oid]);

    // Ambil data user & kirim link WA
    $stmtUser = $pdo->prepare("SELECT u.name, u.phone FROM orders o JOIN user_tbl u ON o.user_id=u.user_id WHERE o.order_id=?");
    $stmtUser->execute([$oid]);
    $user = $stmtUser->fetch(PDO::FETCH_ASSOC);

    $waMsg = getWhatsAppMessageByStatus('paid', $user['name'], $oid, $pdo);
    $waLink = generateWhatsAppLink($user['phone'], $waMsg);

    header("Location: {$waLink}"); // buka WA langsung
    exit;
}

$orders = $pdo->query("SELECT o.*, u.name FROM orders o JOIN user_tbl u ON o.user_id=u.user_id WHERE payment_proof IS NOT NULL AND status='pending'")->fetchAll(PDO::FETCH_ASSOC);
?>
<html>
<head><title>Verifikasi Pembayaran - <?= SITE_NAME ?></title><link rel="stylesheet" href="../assets/css/style.css"></head>
<body>
<div class="container">
    <h2>Verifikasi Pembayaran</h2>
    <table>
        <tr><th>ID</th><th>Customer</th><th>Total</th><th>Bukti</th><th>Aksi</th></tr>
        <?php foreach ($orders as $o): ?>
        <tr>
            <td>#<?= $o['order_id'] ?></td>
            <td><?= $o['name'] ?></td>
            <td><?= rupiah($o['total_price']) ?></td>
            <td><a href="view_payment.php?id=<?= $o['order_id'] ?>" target="_blank">Lihat Bukti</a></td>
            <td><a href="?approve=<?= $o['order_id'] ?>" class="btn btn-success">Approve</a></td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>
</body>
</html>
