<?php
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/admin_auth.php';
require_once __DIR__ . '/../includes/functions.php';
$pageTitle = "Dashboard Admin";
?>
<!DOCTYPE html>
<html>
<head>
    <title><?= $pageTitle ?> - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<header>
    <h1><?= SITE_NAME ?> - Dashboard Admin</h1>
    <nav>
        <a href="index.php">Dashboard</a> | 
        <a href="orders.php">Orders</a> | 
        <a href="products.php">Produk</a> | 
        <a href="categories.php">Kategori</a> | 
        <a href="affiliates.php">Affiliate</a> | 
        <a href="articles.php">Artikel</a> | 
        <a href="payouts.php">Payouts</a> | 
        <a href="logout.php">Logout</a>
    </nav>
</header>

<div class="container">
    <h2>Selamat Datang, Admin!</h2>

    <?php
    $totalOrders = $pdo->query("SELECT COUNT(*) FROM orders")->fetchColumn();
    $pendingOrders = $pdo->query("SELECT COUNT(*) FROM orders WHERE status='pending'")->fetchColumn();
    $paidOrders = $pdo->query("SELECT COUNT(*) FROM orders WHERE status='paid'")->fetchColumn();
    $totalProducts = $pdo->query("SELECT COUNT(*) FROM products")->fetchColumn();
    $totalAffiliates = $pdo->query("SELECT COUNT(*) FROM affiliate_tbl")->fetchColumn();
    ?>

    <div class="products-grid">
        <div class="card"><h3>Total Orders</h3><p><?= $totalOrders ?></p></div>
        <div class="card"><h3>Pending Orders</h3><p><?= $pendingOrders ?></p></div>
        <div class="card"><h3>Paid Orders</h3><p><?= $paidOrders ?></p></div>
        <div class="card"><h3>Total Produk</h3><p><?= $totalProducts ?></p></div>
        <div class="card"><h3>Total Affiliate</h3><p><?= $totalAffiliates ?></p></div>
    </div>

    <h3 style="margin-top:20px;">5 Order Terbaru</h3>
    <?php
    $latestOrders = $pdo->query("
        SELECT o.order_id, u.name, o.total_price, o.status, o.created_at
        FROM orders o 
        JOIN user_tbl u ON o.user_id = u.user_id
        ORDER BY o.created_at DESC LIMIT 5
    ")->fetchAll(PDO::FETCH_ASSOC);
    ?>
    <table>
        <tr><th>ID</th><th>Customer</th><th>Total</th><th>Status</th><th>Tanggal</th></tr>
        <?php foreach ($latestOrders as $lo): ?>
        <tr>
            <td>#<?= $lo['order_id'] ?></td>
            <td><?= $lo['name'] ?></td>
            <td><?= rupiah($lo['total_price']) ?></td>
            <td><?= ucfirst($lo['status']) ?></td>
            <td><?= $lo['created_at'] ?></td>
        </tr>
        <?php endforeach; ?>
    </table>

    <h3 style="margin-top:20px;">Menu Cepat</h3>
    <div class="products-grid">
        <a class="card" href="orders.php"><h4>Kelola Orders</h4></a>
        <a class="card" href="products.php"><h4>Kelola Produk</h4></a>
        <a class="card" href="categories.php"><h4>Kelola Kategori</h4></a>
        <a class="card" href="affiliates.php"><h4>Kelola Affiliate</h4></a>
        <a class="card" href="articles.php"><h4>Kelola Artikel</h4></a>
        <a class="card" href="payouts.php"><h4>Kelola Payouts</h4></a>
    </div>
</div>
</body>
</html>
