<?php
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/admin_auth.php';
require_once __DIR__ . '/../includes/functions.php';

$pageTitle = "Dashboard Admin";

// Statistik
$totalOrders      = $pdo->query("SELECT COUNT(*) FROM orders")->fetchColumn();
$pendingOrders    = $pdo->query("SELECT COUNT(*) FROM orders WHERE status='pending'")->fetchColumn();
$totalAffiliates  = $pdo->query("SELECT COUNT(*) FROM affiliate_tbl")->fetchColumn();
$totalPaidOrders  = $pdo->query("SELECT COUNT(*) FROM orders WHERE status='paid'")->fetchColumn();
$totalProducts    = $pdo->query("SELECT COUNT(*) FROM products")->fetchColumn();
?>
<!DOCTYPE html>
<html>
<head>
    <title><?= $pageTitle ?> - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <style>
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin: 20px 0;
        }
        .stat-card {
            background: white;
            padding: 15px;
            border-radius: 8px;
            box-shadow: 0 1px 4px rgba(0,0,0,0.1);
            text-align: center;
        }
        .stat-card h3 {
            margin-bottom: 5px;
            color: var(--primary);
        }
        .menu-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
            gap: 15px;
            margin-top: 20px;
        }
        .menu-card {
            padding: 15px;
            background: white;
            text-align: center;
            border-radius: 8px;
            box-shadow: 0 1px 4px rgba(0,0,0,0.1);
            transition: 0.2s;
            text-decoration: none;
            color: inherit;
        }
        .menu-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 3px 8px rgba(0,0,0,0.15);
        }
        .menu-card h4 {
            margin-top: 8px;
            font-size: 16px;
        }
    </style>
</head>
<body>
<header>
    <h1>Dashboard Admin</h1>
    <nav>
        <a href="index.php">Home</a> |
        <a href="orders.php">Orders</a> |
        <a href="products.php">Produk</a> |
        <a href="affiliates.php">Affiliate</a> |
        <a href="logout.php">Logout</a>
    </nav>
</header>

<div class="container">
    <!-- Statistik Ringkas -->
    <div class="stats-grid">
        <div class="stat-card">
            <h3><?= $totalOrders ?></h3>
            <p>Total Orders</p>
        </div>
        <div class="stat-card">
            <h3><?= $pendingOrders ?></h3>
            <p>Pending Orders</p>
        </div>
        <div class="stat-card">
            <h3><?= $totalPaidOrders ?></h3>
            <p>Paid Orders</p>
        </div>
        <div class="stat-card">
            <h3><?= $totalAffiliates ?></h3>
            <p>Total Affiliates</p>
        </div>
        <div class="stat-card">
            <h3><?= $totalProducts ?></h3>
            <p>Total Produk</p>
        </div>
    </div>

    <!-- Menu Modul Admin -->
    <h2>Menu Admin</h2>
    <div class="menu-grid">
        <a class="menu-card" href="payments_list.php">💳 Konfirmasi Pembayaran</a>
        <a class="menu-card" href="received_list.php">📥 Produk Diterima</a>
        <a class="menu-card" href="invoices_list.php">🧾 Daftar Invoice</a>
        <a class="menu-card" href="incoming_orders.php">📦 Order Masuk</a>
                <a class="menu-card" href="orders.php">📦<h4>Kelola Orders</h4></a>
        <a class="menu-card" href="products.php">🛒<h4>Kelola Produk</h4></a>
        <a class="menu-card" href="categories.php">🗂<h4>Kategori</h4></a>
        <a class="menu-card" href="affiliates.php">🤝<h4>Affiliate</h4></a>
        <a class="menu-card" href="articles.php">📰<h4>Artikel</h4></a>
        <a class="menu-card" href="payouts.php">💰<h4>Payouts</h4></a>
        <a class="menu-card" href="settings.php">⚙️<h4>Pengaturan</h4></a>
        <a class="menu-card" href="reports.php">📊<h4>Laporan</h4></a>
        <a class="menu-card" href="users.php">👤<h4>Kelola User</h4></a>
        <a class="menu-card" href="settings.php">👤<h4>Setting</h4></a>
        <a class="menu-card" href="digital_resend_list.php">🔄 Kirim Ulang Digital</a>

        <a class="menu-card" href="logout.php">🚪<h4>Logout</h4></a>
    </div>
</div>
</body>
</html>
