<?php
require_once '../includes/db.php';
require_once '../includes/admin_auth.php';

$affiliates = $pdo->query("SELECT a.*, p.name AS parent_name
                           FROM affiliate_tbl a
                           LEFT JOIN affiliate_tbl p ON a.parent_id = p.affiliate_id
                           ORDER BY a.affiliate_id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Data Affiliate - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="container">
    <h2>Data Affiliate</h2>
    <table>
        <tr>
            <th>ID</th><th>Nama</th><th>Email</th><th>Telepon</th><th>Aff Code</th><th>Parent</th>
        </tr>
        <?php foreach ($affiliates as $a): ?>
        <tr>
            <td><?= $a['affiliate_id'] ?></td>
            <td><?= $a['name'] ?></td>
            <td><?= $a['email'] ?></td>
            <td><?= $a['phone'] ?></td>
            <td><?= $a['aff_code'] ?></td>
            <td><?= $a['parent_name'] ?></td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>
</body>
</html>
